/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.global;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.RemoteResponseEvent;
import oracle.ops.mgmt.cluster.RemoteResponseListener;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GlobalHandler
implements RemoteResponseListener {
    RemoteResponseListener m_partialDataHandler;
    RemoteResponseListener m_completeDataHandler;

    public GlobalHandler() {
        this(null, null);
    }

    public GlobalHandler(RemoteResponseListener extlListener) {
        this(extlListener, extlListener);
    }

    public GlobalHandler(RemoteResponseListener partialDataHandler, RemoteResponseListener completeDataHandler) {
        this.m_partialDataHandler = partialDataHandler;
        this.m_completeDataHandler = completeDataHandler;
    }

    public synchronized boolean submit(Command[] cmdArray, int timeLimit, ResultSet resultSet) {
        int cmdCount = cmdArray.length;
        for (int i = 0; i < cmdCount; ++i) {
            VerificationCommand vfyCmd = (VerificationCommand)cmdArray[i];
            String node = vfyCmd.getNodeName();
            Result result = vfyCmd.getResult();
            result.setStatus(5);
            resultSet.addResult(node, result);
        }
        boolean cmdResult = false;
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            cmdResult = clusterCmd.submit(cmdArray);
        }
        catch (ClusterException e) {
            String exceptionMsg = e.getMessage();
            Trace.out((String)("CLUSTEREXCEPTION: " + exceptionMsg + "\n" + Trace.getStackTrace((Throwable)e)));
            Trace.out((String)("GlobalHandler::EXCEPTION: ClusterException[Thread:" + Thread.currentThread().getName() + "]: " + exceptionMsg));
            if (VerificationUtil.isStringGood(exceptionMsg) && !exceptionMsg.contains("1002")) {
                resultSet.addErrorDescription(new ErrorDescription(exceptionMsg));
            }
            VerificationLogData.logError("GlobalHandlerEXCEPTION: " + exceptionMsg + "\n" + Trace.getStackTrace((Throwable)e));
            for (int i = 0; i < cmdCount; ++i) {
                VerificationCommand vfyCmd = (VerificationCommand)cmdArray[i];
                String node = vfyCmd.getNodeName();
                if (!exceptionMsg.contains(node)) continue;
                vfyCmd.setExceptionError(exceptionMsg);
            }
        }
        resultSet.setStatus();
        return resultSet.allSuccess();
    }

    public synchronized boolean submit(Command[] cmdArray, int timeLimit, ResultSet resultSet, int cmdsPerNode) {
        boolean retVal = true;
        ArrayList<Command> cmdList = new ArrayList<Command>();
        List<Command> tmpCmdList = null;
        HashMap<String, List<Command>> nodeMap = new HashMap<String, List<Command>>();
        while (cmdArray.length > 0) {
            nodeMap.clear();
            cmdList.clear();
            for (Command cmd : cmdArray) {
                String node = cmd.getNode();
                tmpCmdList = (List)nodeMap.get(node);
                if (tmpCmdList == null) {
                    tmpCmdList = new ArrayList();
                    nodeMap.put(node, tmpCmdList);
                }
                if (tmpCmdList.size() < cmdsPerNode) {
                    tmpCmdList.add(cmd);
                    continue;
                }
                cmdList.add(cmd);
            }
            tmpCmdList = new ArrayList();
            for (List obj : nodeMap.values()) {
                tmpCmdList.addAll(obj);
            }
            cmdArray = tmpCmdList.toArray(new Command[0]);
            ResultSet rs = new ResultSet();
            this.submit(cmdArray, timeLimit, rs);
            resultSet.uploadResultSet(rs);
            cmdArray = cmdList.toArray(new Command[0]);
        }
        return resultSet.allSuccess();
    }

    public synchronized void partialDataReceived(RemoteResponseEvent e) {
        Trace.out((String)("Entered GlobalHandler::partialDataReceived() [Thread:" + Thread.currentThread().getName() + "]"));
        if (this.m_partialDataHandler != null) {
            this.m_partialDataHandler.partialDataReceived(e);
            return;
        }
        VerificationCommand vfyCmd = (VerificationCommand)e.getCommand();
        Result result = vfyCmd.getResult();
        String nodeName = vfyCmd.getNodeName();
        if (result.getStatus() == 1) {
            Trace.out((String)("GlobalHandler::partialDataReceived: Operation was successful on node:" + nodeName + " [Thread:" + Thread.currentThread().getName() + "]"));
        } else {
            Trace.out((String)("GlobalHandler::partialDataReceived: Operation failed on node:" + nodeName + " [Thread:" + Thread.currentThread().getName() + "]"));
        }
    }

    public synchronized void completeDataReceived(RemoteResponseEvent e) {
        Trace.out((String)("Entered GlobalHandler::completeDataReceived() [Thread:" + Thread.currentThread().getName() + "]"));
        if (this.m_completeDataHandler != null) {
            this.m_completeDataHandler.completeDataReceived(e);
            return;
        }
        Trace.out((String)("GlobalHandler::completeDataReceived: Complete data recevied [Thread:" + Thread.currentThread().getName() + "]"));
    }
}

